//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
#pragma once


// Widok formularza CAssemblyView

typedef	std::map<TableType, META_TABLE_ENTRY> MetaDataMap;
typedef MetaDataMap::const_iterator MetaDataConstantIterator;
typedef MetaDataMap::iterator MetaDataIterator;

class CAssemblyView : public CFormView
{
	DECLARE_DYNCREATE(CAssemblyView)

protected:
	CAssemblyView();           // Chroniony konstruktor uywany do dynamicznego tworzenia
	virtual ~CAssemblyView();

public:
	enum { IDD = IDD_ASSEMBLYVIEW };
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
	CAssemblyDoc* GetDocument();

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // Obsuga DDX/DDV

	DECLARE_MESSAGE_MAP()
public:
	virtual void OnInitialUpdate();

	MetaDataConstantIterator MetaDataBegin() const
	{
		return tables.begin();
	}
	MetaDataConstantIterator MetaDataEnd() const
	{
		return tables.end();
	}

	bool MetaDataTokenToString(mdToken t, std::wstring &s) const;

	MetaDataConstantIterator MetaDataFind(TableType t) const
	{
		return tables.find(t);
	}
	int MetaDataTableCount() const
	{
		return tableCount;
	}
	std::wstring StringTableEntry(DWORD index) const;
	const PBYTE StringTable() const
	{
		return stringsTable;
	}
	DWORD StringTableSize() const
	{
		return stringsTableSize;
	}
	const PBYTE UserStringTable() const
	{
		return userStringsTable;
	}
	DWORD UserStringTableSize() const
	{
		return userStringsTableSize;
	}
	const std::wstring UserStringTableEntry(DWORD index) const;
	std::wstring GUIDTableEntry(DWORD index) const;
	const PBYTE GUIDTable() const
	{
		return guidTable;
	}
	DWORD GUIDTableSize() const
	{
		return guidTableSize;
	}
	const PBYTE BlobTableEntry(DWORD index, PDWORD size) const;
	const PBYTE BlobTable() const
	{
		return blobTable;
	}
	DWORD BlobTableSize() const
	{
		return blobTableSize;
	}


private:
	std::wstring TypeRefName(const META_TABLE_ENTRY& t, DWORD index) const;
	std::wstring TypeDefName(const META_TABLE_ENTRY& t, DWORD index) const;
	DWORD TableRowSizes(TableType tableID);
	template <class T> void GetTableInformation( PBYTE pImageBase, T* pNTHeader );
	CPropertySheet m_dlgPropSheet;
	CBlobHeapPage m_blobPage;
	CStringHeapPage m_stringPage;
	CUserStringHeapPage m_userStringPage;
	CGUIDHeapPage m_guidPage;
	CMetadataTablesPage m_tablesPage;
	CFileHeaderPropertiesPage m_filePropertiesPage;
	COptionalHeaderPropertiesPage m_optionalHeaderPropertiesPage;
	CDataDirectoryPage m_dataDirectoryPage;
	CSectionPage m_sectionPage;
	CImportPage m_importPage;
	CImportAddressPage m_importAddressPage;
	CCILHeaderPage m_cilHeaderPage;

	PMETA_COMPOSITE_HEADER compositeTable;
	MetaDataMap tables;
	int tableCount;
	PBYTE stringsTable;
	DWORD stringsTableSize;
	PBYTE userStringsTable;
	DWORD userStringsTableSize;
	PBYTE blobTable;
	DWORD blobTableSize;
	PBYTE guidTable;
	DWORD guidTableSize;

public:
};

#ifndef _DEBUG  // Wersja debug w pliku HelloVw.cpp
inline CAssemblyDoc* CAssemblyView::GetDocument()
   { return (CAssemblyDoc*)m_pDocument; }
#endif


